# Quiz4 API Documentation

Base URL: `https://quiz4.snaplimit.com/user/`

## Authentication

All authenticated endpoints require the following headers:
- `Device-ID`: Unique device identifier
- `Session-Token`: Session authentication token

**Note:** All request and response bodies are encrypted using a custom encryption algorithm (base64 + vowel obfuscation). The examples below show the unencrypted JSON structure that needs to be encrypted before sending.

---

## Endpoints

### 1. Account Management

#### 1.1 Login/Signup
**Endpoint:** `POST /user/account.php`

**Description:** Handles user login and signup with a "one device, one account" policy.

**Headers:**
```
Device-ID: <device_id> (required)
```

**Request Body (Unencrypted):**
```json
{
  "email": "user@example.com",
  "device_id": "unique_device_id_123",
  "refercode": "optional_referral_code" // Optional, 8 alphanumeric characters
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/account.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Login successful",
  "data": {
    "user_id": 1,
    "email": "user@example.com",
    "refercode": "user1234",
    "coins": 1000,
    "can_claim": true
  },
  "session_token": "encrypted_session_token_64_chars"
}
```

**Error Responses:**
- `400`: Missing or empty field, Device already used, Email already registered
- `429`: Too many requests
- `500`: Database connection failed

---

### 2. Home & App Settings

#### 2.1 Get Home Data
**Endpoint:** `POST /user/home.php`

**Description:** Fetches home screen data including app settings and user coins.

**Actions:**
- `public`: No authentication required
- `auth`: Requires authentication

**Request Body (Unencrypted):**
```json
{
  "action": "auth", // or "public"
  "user_id": 1 // Required for "auth" action
}
```

**cURL Example (Public):**
```bash
curl -X POST https://quiz4.snaplimit.com/user/home.php \
  -H "Content-Type: application/json" \
  --data-binary "<encrypted_payload>"
```

**cURL Example (Authenticated):**
```bash
curl -X POST https://quiz4.snaplimit.com/user/home.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Home data fetched",
  "data": {
    "maintenance": false,
    "vpn_allowed": true,
    "guest_mode": false,
    "earning_mode": true,
    "gamezop_timer": 30,
    "ad_index": 3,
    "gamezop_card_status": true,
    "ad_app_size": "large",
    "ad_controls": [],
    "user_coins": 1000,
    "daily_checkin": {
      "can_claim": true
    },
    "links": {
      "how_to": "https://example.com/howto",
      "telegram": "https://t.me/example",
      "support": "https://example.com/support"
    }
  },
  "new_session_token": "new_session_token"
}
```

---

#### 2.2 Get App Settings
**Endpoint:** `POST /user/app_settings.php`

**Description:** Fetches detailed app settings including update information and ad settings.

**Actions:**
- `public`: No authentication required
- `user_blocked`: Requires authentication, checks if user is blocked

**Request Body (Unencrypted):**
```json
{
  "action": "public", // or "user_blocked"
  "user_id": 1 // Required for "user_blocked" action
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/app_settings.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "App settings fetched",
  "data": {
    "update": {
      "app_link": "https://play.google.com/...",
      "app_base_url": "https://example.com",
      "version": "1.0.0",
      "version_code": 1,
      "changelogs": "Bug fixes and improvements"
    },
    "maintenance": false,
    "vpn_allowed": true,
    "guest_mode": false,
    "earning_mode": true,
    "gamezop_timer": 30,
    "gamezop_card_status": true,
    "ad_app_size": "large",
    "packages": "com.example.app",
    "update_mode": "off",
    "ads_settings": {
      "app_id": "ca-app-pub-...",
      "interstitial_ad_unit": "ca-app-pub-...",
      "native_ad_unit": "ca-app-pub-...",
      "banner_ad_unit": "ca-app-pub-...",
      "reward_ad_unit": "ca-app-pub-...",
      "appopen_ad_unit": "ca-app-pub-..."
    },
    "ad_controls": [],
    "is_blocked": false,
    "user_coins": 1000,
    "daily_checkin": {
      "can_claim": true
    },
    "links": {
      "how_to": "https://example.com/howto",
      "telegram": "https://t.me/example",
      "support": "https://example.com/support",
      "privacy_policy": "https://example.com/privacy",
      "delete_account": "https://example.com/delete"
    }
  },
  "new_session_token": "new_session_token"
}
```

---

### 3. Daily Check-in

#### 3.1 Daily Check-in Status
**Endpoint:** `POST /user/checkin_status.php`

**Description:** Checks daily check-in status for the user.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/checkin_status.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Checkin status fetched",
  "data": {
    "can_claim": true,
    "coins_reward": 50,
    "last_claimed": "2025-01-15 10:30:00",
    "next_available": "2025-01-16 00:00:00",
    "streak_days": 3
  },
  "new_session_token": "new_session_token"
}
```

---

#### 3.2 Claim Daily Check-in
**Endpoint:** `POST /user/daily_checkin.php`

**Description:** Claims daily check-in coins for the user.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "earned_coins": 50 // Optional, if not provided uses app settings
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/daily_checkin.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Daily checkin claimed successfully",
  "data": {
    "coins_earned": 50,
    "total_coins": 1050,
    "next_checkin_available": "2025-01-16 00:00:00"
  },
  "new_session_token": "new_session_token"
}
```

**Error Responses:**
- `400`: Invalid user_id, Already claimed today
- `401`: Unauthorized
- `429`: Too many requests
- `500`: Database connection failed

---

### 4. Tasks

#### 4.1 Get Task Questions
**Endpoint:** `POST /user/task_questions.php`

**Description:** Fetches a specified number of questions for a specific task type.

**Task Types:**
- `math_fun`
- `alphabet_find`
- `sound_match`
- `big_vs_small`

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "task_type": "math_fun",
  "limit": 10 // Optional, default 10, max 50
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/task_questions.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Questions fetched",
  "data": {
    "questions": [
      {
        "id": 1,
        "task_type": "math_fun",
        "question": "What is 2 + 2?",
        "options": ["3", "4", "5", "6"],
        "correct_answer": "4"
      }
    ],
    "reward_coins": "10-20"
  },
  "new_session_token": "new_session_token"
}
```

**Error Responses:**
- `400`: Invalid user_id, Invalid task_type, Invalid limit, No questions found
- `401`: Unauthorized
- `429`: Too many requests
- `500`: Database connection failed

---

#### 4.2 Get Task Limits
**Endpoint:** `POST /user/task_limits.php`

**Description:** Fetches task limits and usage information for the user.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "task_type": "math_fun" // Optional, if not provided returns all task types
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/task_limits.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Task limits fetched",
  "data": {
    "enabled": true,
    "earning_mode": true,
    "vpn_allowed": true,
    "native_ad_load_refresh_count": 5,
    "coins": 1000,
    "limits": [
      {
        "task_type": "math_fun",
        "daily_limit": 10,
        "used_count": 3,
        "remaining_limit": 7,
        "reward_coins": 15,
        "ad_index": 2,
        "important_ad_type": "inter"
      }
    ],
    "ad_index": [2]
  },
  "new_session_token": "new_session_token"
}
```

---

#### 4.3 Complete Task
**Endpoint:** `POST /user/complete_task.php`

**Description:** Checks task completion and returns response data without updating coins. This is called before final submission.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "earned_coins": 15,
  "by_task": "math_fun",
  "created_at": "2025-01-15 10:30:00" // Optional
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/complete_task.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Task completed",
  "data": {
    "show_ad": true,
    "claim_timer": 5,
    "website_task": null,
    "task_limits": {
      "enabled": true,
      "remaining_limit": 6,
      "daily_limit": 10
    },
    "total_coins": 1000,
    "referral_reward": {
      "awarded": false
    }
  },
  "new_session_token": "new_session_token"
}
```

**Error Responses:**
- `400`: Daily limit reached for task type
- `401`: Unauthorized
- `429`: Too many requests
- `500`: Database connection failed

---

#### 4.4 Final Submit Task
**Endpoint:** `POST /user/final_submit.php`

**Description:** Final submission of task completion. Updates user coins and task completion records.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "earned_coins": 15,
  "by_task": "math_fun",
  "created_at": "2025-01-15 10:30:00" // Optional
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/final_submit.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Final submission completed successfully",
  "data": {
    "total_coins": 1015,
    "earned_coins": 15,
    "show_ad": true,
    "limits": [
      [
        ["daily_limit", 10],
        ["remaining_limit", 6],
        ["task_type", "math_fun"],
        ["used_count", 4]
      ]
    ]
  },
  "new_session_token": "new_session_token"
}
```

**Error Responses:**
- `400`: Daily limit reached for task type
- `401`: Unauthorized
- `429`: Too many requests
- `500`: Failed to complete final submission

---

### 5. Referral

#### 5.1 Apply Referral Code
**Endpoint:** `POST /user/apply_refercode.php`

**Description:** Applies a referral code to the user's account.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "refercode": "user1234" // 8 alphanumeric characters
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/apply_refercode.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Referral code applied successfully",
  "data": {
    "message": "Referral code applied successfully! You will receive your referral reward after your first successful redeem."
  },
  "new_session_token": "new_session_token"
}
```

**Error Responses:**
- `400`: Invalid referral code format, Already used a referral code, Cannot use own referral code, Invalid referral code
- `401`: Unauthorized
- `429`: Too many requests
- `500`: Failed to apply referral code

---

### 6. Promo Codes

#### 6.1 Apply Promo Code
**Endpoint:** `POST /user/promocode.php`

**Description:** Applies a promo code to award coins.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "code": "PROMO123"
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/promocode.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Promo code applied",
  "data": {
    "coins_awarded": 100,
    "coins": 1100
  },
  "new_session_token": "new_session_token"
}
```

**Error Responses:**
- `400`: Invalid input, Invalid promo code, Promo code expired, Usage limit reached, Already used
- `401`: Unauthorized
- `429`: Too many requests
- `500`: Database connection failed

---

### 7. Redeem

#### 7.1 List Redeem Categories
**Endpoint:** `POST /user/redeem.php`

**Action:** `list_categories`

**Description:** Fetches all redeem categories.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "action": "list_categories"
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/redeem.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Categories fetched",
  "data": {
    "categories": [
      {
        "category_id": 1,
        "category_name": "Gift Card & Payments",
        "category_image_url": "https://example.com/image.png"
      }
    ]
  },
  "new_session_token": "new_session_token"
}
```

---

#### 7.2 List Redeem Subcategories
**Endpoint:** `POST /user/redeem.php`

**Action:** `list_subcategories`

**Description:** Fetches subcategories for a specific category.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "action": "list_subcategories",
  "category_id": 1,
  "sub_category_name": "Google Play" // Optional, filters for Google Play
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/redeem.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Subcategories fetched",
  "data": {
    "subcategories": [
      {
        "id": 1,
        "sub_category_name": "Google Play ₹100",
        "sub_category_image_url": "https://example.com/image.png",
        "coins": 1000,
        "cash": 100,
        "is_enabled": true
      }
    ]
  },
  "new_session_token": "new_session_token"
}
```

---

#### 7.3 Redeem Coins
**Endpoint:** `POST /user/redeem.php`

**Action:** `redeem`

**Description:** Redeems coins for a gift card or cash reward. Requires:
1. Daily withdraw limit not reached
2. All daily tasks completed
3. Sufficient coins

**Request Body (Unencrypted):**
```json
{
  "user_id": 1,
  "action": "redeem",
  "subcategory_id": 1
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/redeem.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Redeem request successful",
  "data": {
    "coins": 900,
    "gift_code": "GIFTCODE123",
    "created_at": "15/01/2025 10:30 AM"
  },
  "new_session_token": "new_session_token"
}
```

**Error Responses:**
- `400`: Missing or invalid subcategory_id, Redeem option is disabled, Daily withdraw limit reached, Complete all daily tasks before withdrawing, Insufficient coins, Currently Codes Not Available
- `401`: Unauthorized
- `429`: Too many requests
- `500`: Database connection failed

---

#### 7.4 Get Redeem History
**Endpoint:** `POST /user/redeem_history.php`

**Description:** Fetches redeem history for the user.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/redeem_history.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Redeem history fetched",
  "data": {
    "history": [
      {
        "id": 1,
        "redeem_option_name": "Gift Card & Payments - Google Play ₹100",
        "image_url": "https://example.com/image.png",
        "gift_code": "GIFTCODE123",
        "pin": "1234",
        "status": "approved",
        "rejection_reason": null,
        "cash": 100,
        "created_at": "15/01/2025 10:30 AM"
      }
    ]
  },
  "new_session_token": "new_session_token"
}
```

---

### 8. Gamezop API

#### 8.1 Gamezop Games API
**Endpoint:** `GET /user/gamezop_api.php`

**Description:** Proxy API for Gamezop games. Supports various actions for searching and filtering games.

**Query Parameters:**
- `action`: `search`, `category`, `tag`, `all`, `list-categories`, `list-tags`, `game-details`
- `query`: Search query (for `search` action)
- `name`: Category name (for `category` action)
- `tag`: Tag name (for `tag` action)
- `code`: Game code (for `game-details` action)

**cURL Examples:**

**Search Games:**
```bash
curl -X GET "https://quiz4.snaplimit.com/user/gamezop_api.php?action=search&query=pop"
```

**Get Games by Category:**
```bash
curl -X GET "https://quiz4.snaplimit.com/user/gamezop_api.php?action=category&name=Puzzle%20%26%20Logic"
```

**Get Games by Tag:**
```bash
curl -X GET "https://quiz4.snaplimit.com/user/gamezop_api.php?action=tag&tag=arcade"
```

**Get All Games:**
```bash
curl -X GET "https://quiz4.snaplimit.com/user/gamezop_api.php?action=all"
```

**List All Categories:**
```bash
curl -X GET "https://quiz4.snaplimit.com/user/gamezop_api.php?action=list-categories"
```

**List All Tags:**
```bash
curl -X GET "https://quiz4.snaplimit.com/user/gamezop_api.php?action=list-tags"
```

**Get Game Details:**
```bash
curl -X GET "https://quiz4.snaplimit.com/user/gamezop_api.php?action=game-details&code=SJX7TGkDq1X"
```

**Success Response (200):**
```json
{
  "games": [
    {
      "code": "SJX7TGkDq1X",
      "name": {
        "en": "Game Name"
      },
      "description": {
        "en": "Game Description"
      },
      "categories": {
        "en": ["Puzzle & Logic"]
      },
      "tags": {
        "en": ["arcade"]
      }
    }
  ]
}
```

---

### 9. Account Management

#### 9.1 Transfer User Data
**Endpoint:** `POST /user/transfer_user_data.php`

**Description:** Transfers user data from current app to another app's database. User's coins are reset to 0 in current app after successful transfer.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/transfer_user_data.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "User data transferred successfully",
  "data": {
    "transferred_coins": 1000,
    "new_app_user_id": 5,
    "message": "Your data has been successfully transferred to the new app. Your coins in this app have been reset to 0."
  },
  "new_session_token": "new_session_token"
}
```

**Error Responses:**
- `400`: Invalid user_id, User data already transferred, User not found
- `401`: Unauthorized
- `429`: Too many requests
- `500`: Database connection failed, Transfer failed

**Note:** 
- The new app's database configuration must be set in `new_app_config.php`
- User data is checked for duplicates (by email or device_id) before transfer
- After successful transfer, user's coins in current app are set to 0
- All user table fields are transferred: email, device_id, coins, refercode, referred_by, created_at, is_blocked

---

#### 9.2 Logout
**Endpoint:** `POST /user/logout.php`

**Description:** Logs out the user and invalidates the session token.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/logout.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Logout successful"
}
```

---

#### 9.3 Delete Account
**Endpoint:** `POST /user/delete_account.php`

**Description:** Permanently deletes the user account and all associated data.

**Request Body (Unencrypted):**
```json
{
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST https://quiz4.snaplimit.com/user/delete_account.php \
  -H "Content-Type: application/json" \
  -H "Device-ID: unique_device_id_123" \
  -H "Session-Token: session_token_here" \
  --data-binary "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Account deleted successfully"
}
```

**Error Responses:**
- `400`: Invalid user_id
- `401`: Unauthorized
- `429`: Too many requests
- `500`: Failed to delete account

---

## Encryption/Decryption

All request and response bodies are encrypted using a custom algorithm:

1. **Encryption Process:**
   - Base64 encode the JSON string
   - Replace vowels with special character sequences:
     - `a/A` → `w%sy5f` / `W%SY5F`
     - `e/E` → `p#r9v2` / `P#R9V2`
     - `i/I` → `m&j4q8` / `M&J4Q8`
     - `o/O` → `t!k7w3` / `T!K7W3`
     - `u/U` → `z@x6n0` / `Z@X6N0`

2. **Decryption Process:**
   - Reverse the vowel replacements
   - Base64 decode the result

**Note:** When implementing client-side requests, you must encrypt the JSON payload before sending and decrypt the response after receiving.

---

## Common Error Codes

- `400`: Bad Request - Invalid input, missing required fields, business logic errors
- `401`: Unauthorized - Invalid or expired session token
- `405`: Method Not Allowed - Wrong HTTP method used
- `429`: Too Many Requests - Rate limit exceeded
- `500`: Internal Server Error - Database connection failed or server error

---

## Rate Limiting

The API implements rate limiting based on user ID. Default limit is 100 requests per hour per user. The exact limit can be configured in `app_settings.rate_limit_count`.

---

## Session Tokens

- Session tokens are 64-character hexadecimal strings
- Tokens expire after 30 days
- A new session token is generated on most authenticated requests
- Always use the `new_session_token` from responses for subsequent requests

---

## Notes

1. All timestamps are in `Asia/Kolkata` timezone
2. All dates are formatted as `YYYY-MM-DD`
3. All date-time values are formatted as `YYYY-MM-DD HH:MM:SS`
4. Task types have been updated:
   - `number_game` → `math_fun`
   - `guess_alphabet` → `alphabet_find`
   - `fruit_finder` → `sound_match`
   - `logo_quiz` → `big_vs_small`
5. All monetary values are in coins or cash (as specified)
6. Redeem operations require completing all daily tasks before withdrawal

---

## Support

For API support, contact:
- Telegram: [Check app_settings for telegram_link]
- Support: [Check app_settings for support_link]

---

**Last Updated:** January 2025

